/*
 * Decompiled with CFR 0.152.
 */
package gmconverter;

import gmconverter.GM6FileFilter;
import gmconverter.ImageFilter;
import gmconverter.MainFrame;
import gmconverter.Project;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class ProjectPropertiesFrame
extends JFrame {
    private JDialog owner;
    private MainFrame mainFrame;
    private JButton CancelButton;
    private JFileChooser FileChooser;
    private JButton OKButton;
    private JSeparator bottomSeparator;
    private JTextField gmFileField;
    private JLabel gmfileLabel;
    private JSeparator middleSeparator;
    private JTextField midletIconField;
    private JLabel midletIconLabel;
    private JTextField midletNameField;
    private JLabel midletNameLabel;
    private JLabel pjtDirLabel;
    private JLabel pjtNameLabel;
    private JTextField projectDirectoryField;
    private JTextField projectNameField;
    private JButton selectGmFileButton;
    private JButton selectIconButton;
    private JButton selectPjtDirButton;
    private JLabel titleLabel;
    private JSeparator topSeparator;
    private JTextField vendorField;
    private JLabel vendorLabel;

    public ProjectPropertiesFrame(MainFrame mainframe, Project project, JDialog dialog, boolean newProject) {
        this.initComponents();
        this.owner = dialog;
        this.mainFrame = mainframe;
        this.projectNameField.setText(project.getName());
        this.projectDirectoryField.setText(project.getProjectDir());
        this.gmFileField.setText(project.getGmfilePath());
        this.vendorField.setText(project.getVendor());
        this.midletNameField.setText(project.getMidletName());
        this.midletIconField.setText(project.getMidletIconPath());
        if (!newProject) {
            this.projectNameField.setEditable(false);
            this.projectDirectoryField.setEditable(false);
            this.gmFileField.setEditable(false);
            this.selectPjtDirButton.setEnabled(false);
            this.selectGmFileButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.FileChooser = new JFileChooser();
        this.titleLabel = new JLabel();
        this.pjtNameLabel = new JLabel();
        this.projectNameField = new JTextField();
        this.pjtDirLabel = new JLabel();
        this.projectDirectoryField = new JTextField();
        this.selectPjtDirButton = new JButton();
        this.gmfileLabel = new JLabel();
        this.gmFileField = new JTextField();
        this.selectGmFileButton = new JButton();
        this.vendorLabel = new JLabel();
        this.midletNameLabel = new JLabel();
        this.midletIconLabel = new JLabel();
        this.vendorField = new JTextField();
        this.midletNameField = new JTextField();
        this.midletIconField = new JTextField();
        this.selectIconButton = new JButton();
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.topSeparator = new JSeparator();
        this.middleSeparator = new JSeparator();
        this.bottomSeparator = new JSeparator();
        this.setDefaultCloseOperation(0);
        this.setTitle("Project properties");
        this.setResizable(false);
        this.titleLabel.setFont(new Font("Monospaced", 1, 14));
        this.titleLabel.setText("Project properties :");
        this.pjtNameLabel.setText("Project Name :");
        this.projectNameField.setFont(new Font("Monospaced", 0, 12));
        this.pjtDirLabel.setText("Project Directory:");
        this.selectPjtDirButton.setText("Browse ...");
        this.selectPjtDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesFrame.this.selectPjtDirButtonActionPerformed(evt);
            }
        });
        this.gmfileLabel.setText("GameMaker (*.gm6) file :");
        this.selectGmFileButton.setText("Browse ...");
        this.selectGmFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesFrame.this.selectGmFileButtonActionPerformed(evt);
            }
        });
        this.vendorLabel.setText("Vendor:");
        this.midletNameLabel.setText("MIDlet-name:");
        this.midletIconLabel.setText("MIDlet Icon :");
        this.selectIconButton.setText("Browse ...");
        this.selectIconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesFrame.this.selectIconButtonActionPerformed(evt);
            }
        });
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesFrame.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPropertiesFrame.this.CancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.middleSeparator, -1, 455, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.topSeparator, -1, 455, Short.MAX_VALUE).add(1, (Component)this.pjtDirLabel, -2, 96, -2).add(1, (Component)this.titleLabel, -2, 166, -2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pjtNameLabel, -2, 81, -2).add(17, 17, 17).add((Component)this.projectNameField, -1, 357, Short.MAX_VALUE)).add(1, (Component)this.gmfileLabel, -2, 152, -2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(184, 184, 184).add((Component)this.CancelButton)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.projectDirectoryField).add(1, (Component)this.gmFileField, -1, 249, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.selectGmFileButton, -1, 200, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.selectPjtDirButton, -1, 202, Short.MAX_VALUE))))).addPreferredGap(0)))).add((GroupLayout.Group)layout.createSequentialGroup().add(99, 99, 99).add((Component)this.OKButton, -2, 66, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.bottomSeparator, -1, 455, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.midletNameLabel).add((Component)this.midletIconLabel).add((Component)this.vendorLabel, -2, 56, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.vendorField, -1, 386, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.midletIconField, -2, 181, -2).add(5, 5, 5).add((Component)this.selectIconButton, -1, 200, Short.MAX_VALUE)).add((Component)this.midletNameField, -1, 386, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.topSeparator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pjtNameLabel).add((Component)this.projectNameField, -2, 18, -2)).addPreferredGap(0).add((Component)this.pjtDirLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.selectPjtDirButton).add((Component)this.projectDirectoryField, -2, -1, -2)).addPreferredGap(0).add((Component)this.gmfileLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.gmFileField, -2, -1, -2).add((Component)this.selectGmFileButton)).addPreferredGap(0).add((Component)this.middleSeparator, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.vendorLabel).add((Component)this.vendorField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.midletNameLabel).add((Component)this.midletNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.midletIconLabel).add((Component)this.selectIconButton).add((Component)this.midletIconField, -2, -1, -2)).addPreferredGap(0).add((Component)this.bottomSeparator, -2, 10, -2).addPreferredGap(0, 40, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.OKButton).add((Component)this.CancelButton)).add(22, 22, 22)));
        this.pack();
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        MainFrame.newProject = null;
        this.dispose();
        this.owner.setVisible(false);
    }

    private void selectIconButtonActionPerformed(ActionEvent evt) {
        JFileChooser iconChooser = new JFileChooser();
        iconChooser.setFileFilter(new ImageFilter());
        iconChooser.setCurrentDirectory(new File(this.mainFrame.currentDir));
        iconChooser.showDialog(this, "Select midlet icon");
        this.mainFrame.currentDir = iconChooser.getCurrentDirectory().getPath();
        File f = iconChooser.getSelectedFile();
        if (f != null) {
            this.midletIconField.setText(f.getPath());
        } else {
            this.midletIconField.setText("");
        }
    }

    private void selectGmFileButtonActionPerformed(ActionEvent evt) {
        this.FileChooser.setFileSelectionMode(2);
        this.FileChooser.setFileFilter(new GM6FileFilter());
        this.FileChooser.setCurrentDirectory(new File(this.mainFrame.currentDir));
        this.FileChooser.showDialog(this, "Select *.gm6 file");
        this.mainFrame.currentDir = this.FileChooser.getCurrentDirectory().getPath();
        File f = this.FileChooser.getSelectedFile();
        if (f != null) {
            this.gmFileField.setText(f.getPath());
        } else {
            this.gmFileField.setText("");
        }
    }

    private void selectPjtDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setFileSelectionMode(1);
        fChooser.setCurrentDirectory(new File(this.mainFrame.currentDir));
        fChooser.showDialog(this, "Select directory");
        this.mainFrame.currentDir = fChooser.getCurrentDirectory().getPath();
        File f = fChooser.getSelectedFile();
        if (f != null) {
            this.projectDirectoryField.setText(f.getPath());
        } else {
            this.projectDirectoryField.setText("");
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        File tmpclasses;
        File classes;
        File build;
        String iconPath;
        File im;
        String pjtName = this.projectNameField.getText().trim();
        if (pjtName.length() == 0) {
            JOptionPane.showMessageDialog(this, "Error in project name field", "Error", 0);
            return;
        }
        File f = new File(this.projectDirectoryField.getText().trim());
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "Project Directory not exist", "Error", 0);
            return;
        }
        String projectDir = this.projectDirectoryField.getText().trim();
        f = new File(this.gmFileField.getText().trim());
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "Error in Game Maker (*.gm6) file field: file not found or not accessible", "Error", 0);
            return;
        }
        String gm6File = this.gmFileField.getText().trim();
        if (!this.midletIconField.getText().trim().equalsIgnoreCase("") && !(im = new File(iconPath = this.midletIconField.getText().trim())).exists()) {
            JOptionPane.showMessageDialog(this, "Error in MIDlet icon file field: file not found or not accessible", "Error", 0);
            return;
        }
        String iconFile = this.midletIconField.getText().trim();
        String vendorName = this.vendorField.getText().trim().equalsIgnoreCase("") ? new Project("").getVendor() : this.vendorField.getText().trim();
        String mName = this.midletNameField.getText().trim().equalsIgnoreCase("") ? new Project("").getMidletName() : this.midletNameField.getText().trim();
        String pjtFilename = "";
        StringTokenizer tokenizer = new StringTokenizer(pjtName, " \t\n.,\"'", false);
        while (tokenizer.hasMoreTokens()) {
            pjtFilename = pjtFilename + tokenizer.nextToken();
        }
        Project newProject = new Project(pjtName);
        newProject.setProjectFileName(pjtFilename);
        newProject.setProjectDir(projectDir);
        newProject.setGmfilePath(gm6File);
        newProject.setVendor(vendorName);
        newProject.setMidletName(mName);
        newProject.setMidletIconPath(iconFile);
        File source = new File(newProject.getProjectDir() + File.separator + "source");
        if (!source.exists()) {
            if (!source.mkdir()) {
                JOptionPane.showMessageDialog(this, "Error in project saving procedure: can't create source directory", "Error", 0);
                this.mainFrame.setInactiveProject();
                this.dispose();
                this.owner.setVisible(false);
            }
        } else {
            File[] files = source.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        if (!(build = new File(newProject.getProjectDir() + File.separator + "build")).exists() && !build.mkdir()) {
            JOptionPane.showMessageDialog(this, "Error in project saving procedure: can't create build directory", "Error", 0);
            this.mainFrame.setInactiveProject();
            this.dispose();
            this.owner.setVisible(false);
        }
        if (!(classes = new File(build.getPath() + File.separator + "classes")).exists()) {
            if (!classes.mkdir()) {
                JOptionPane.showMessageDialog(this, "Error in project saving procedure: can't create classes directory", "Error", 0);
                this.mainFrame.setInactiveProject();
                this.dispose();
                this.owner.setVisible(false);
            }
        } else {
            File[] files = classes.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        if (!(tmpclasses = new File(build.getPath() + File.separator + "tmpclasses")).exists()) {
            if (!tmpclasses.mkdir()) {
                JOptionPane.showMessageDialog(this, "Error in project saving procedure: can't create temp classes directory", "Error", 0);
                this.mainFrame.setInactiveProject();
                this.dispose();
                this.owner.setVisible(false);
            }
        } else {
            File[] files = tmpclasses.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        if (!newProject.saveToFile()) {
            JOptionPane.showMessageDialog(this, "Error in project saving procedure!", "Error", 0);
            this.mainFrame.setInactiveProject();
            this.dispose();
            this.owner.setVisible(false);
        } else {
            this.mainFrame.setActiveProject(newProject);
            this.dispose();
            this.owner.setVisible(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

