/*
 * Decompiled with CFR 0.152.
 */
package gmconverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Project {
    private String name;
    private String projectDir;
    private String gmfilePath;
    private String vendor;
    private String midletName;
    private String midletIconPath;
    private String projectFilename;
    public boolean sucessBuild;

    public Project(String n) {
        this.name = n;
        this.projectDir = "";
        this.gmfilePath = "";
        this.vendor = "Game Maker Converter Version 2.0.1";
        this.midletName = "newMidlet";
        this.midletIconPath = "";
        this.projectFilename = "project.gpjt";
        this.sucessBuild = false;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getGmfilePath() {
        return this.gmfilePath;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getMidletName() {
        return this.midletName;
    }

    public String getMidletIconPath() {
        return this.midletIconPath;
    }

    public String getProjectFilename() {
        return this.projectFilename;
    }

    public void setName(String n_name) {
        if (n_name != null) {
            this.name = n_name;
        }
    }

    public void setProjectDir(String pDir) {
        if (pDir != null) {
            this.projectDir = pDir;
        }
    }

    public void setGmfilePath(String gPath) {
        if (gPath != null) {
            this.gmfilePath = gPath;
        }
    }

    public void setVendor(String v) {
        if (v != null) {
            this.vendor = v;
        }
    }

    public void setMidletName(String mName) {
        if (mName != null) {
            this.midletName = mName;
        }
    }

    public void setMidletIconPath(String mPath) {
        if (mPath != null) {
            this.midletIconPath = mPath;
        }
    }

    public void setProjectFileName(String pFname) {
        if (pFname != null) {
            this.projectFilename = pFname;
        }
    }

    public boolean saveToFile() {
        String fname = this.projectDir + File.separator + this.projectFilename + ".gpjt";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(fname)));
            writer.write(this.projectFilename);
            writer.newLine();
            writer.write(this.name);
            writer.newLine();
            writer.write(this.projectDir);
            writer.newLine();
            writer.write(this.gmfilePath);
            writer.newLine();
            writer.write(this.vendor);
            writer.newLine();
            writer.write(this.midletName);
            writer.newLine();
            writer.write(this.midletIconPath);
            writer.newLine();
            writer.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean readFromFile(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(filename)));
            String str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.projectFilename = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.name = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.projectDir = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.gmfilePath = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.vendor = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.midletName = str;
            str = reader.readLine();
            if (str == null) {
                reader.close();
                return false;
            }
            this.midletIconPath = str;
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

