/*
 * Decompiled with CFR 0.152.
 */
package gmconverter;

import gmconverter.BuildProjectException;
import gmconverter.ConverterProperties;
import gmconverter.PjtFileFilter;
import gmconverter.Project;
import gmconverter.ProjectPropertiesFrame;
import gmj2meconverter.ConverterLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class MainFrame
extends JFrame {
    public String jdkPath = null;
    public String wtkPath = null;
    public static String CONFIG_FILE_NAME = "gmc_config.conf";
    public String currentDir = "";
    public Color green;
    public Color red;
    public Color gray;
    private JButton BuildProjectButton;
    private JButton ClearConsoleButton;
    private JButton OpenProjectButton;
    private JProgressBar ProgressBar;
    private JButton RunProjectButton;
    private JLabel StageLabel;
    private JMenuItem buildProject;
    private JMenu converterMenu;
    private JMenuItem converterSettings;
    private JMenuItem createProject;
    private JMenuItem exitProgram;
    private JMenu fileMenu;
    private JSeparator fileseparator;
    private JMenuItem help;
    private JMenu helpMenu;
    private JDialog jDialog1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea mainConsole;
    private JMenuItem openProject;
    private JMenuItem pjtSettings;
    private JSeparator pjtseparator;
    private JMenu projectMenu;
    private JMenuItem runProject;
    public static Project currentProject;
    public static Project newProject;

    public MainFrame() {
        this.initComponents();
        this.setInactiveProject();
        this.mainConsole.setEditable(false);
        this.mainConsole.setFont(new Font("Monospaced", 0, 12));
        File cfg = new File(CONFIG_FILE_NAME);
        if (!cfg.exists()) {
            JOptionPane.showMessageDialog(this, "Can't find config file. Probably, this is a first start of program,  please use \"Converter->Converter settings\" for next work", "First time?", 1);
        } else {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(cfg));
                this.jdkPath = reader.readLine();
                this.wtkPath = reader.readLine();
                reader.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Can't read config file, please use \"Converter->Converter settings\" for valid updating", "Error at the reading config", 0);
                this.jdkPath = null;
                this.wtkPath = null;
            }
        }
        this.testConfigPaths();
        this.green = new Color(51, 153, 51);
        this.red = new Color(119, 51, 51);
        this.gray = new Color(51, 51, 51);
    }

    public boolean testConfigPaths() {
        if (this.jdkPath != null && this.wtkPath != null) {
            File testJDKcpl = new File(this.jdkPath + File.separator + "bin" + File.separator + "javac.exe");
            File testJDKjar = new File(this.jdkPath + File.separator + "bin" + File.separator + "jar.exe");
            File testWTKlib = new File(this.wtkPath + File.separator + "lib" + File.separator + "midpapi20.jar");
            File testWTKcldc = new File(this.wtkPath + File.separator + "lib" + File.separator + "cldcapi11.jar");
            if (!testJDKcpl.exists()) {
                JOptionPane.showMessageDialog(this, "Can't find \"" + testJDKcpl.getPath() + "\" file, please use \"Converter->Converter settings\" for settings", "JDK path error", 0);
                this.jdkPath = null;
                return false;
            }
            if (!testJDKjar.exists()) {
                JOptionPane.showMessageDialog(this, "Can't find \"" + testJDKjar.getPath() + "\" file, please use \"Converter->Converter settings\" for settings", "JDK path error", 0);
                this.jdkPath = null;
                return false;
            }
            if (!testWTKlib.exists()) {
                JOptionPane.showMessageDialog(this, "Can't find \"" + testWTKlib.getPath() + "\" file, please use \"Converter->Converter settings\" for settings", "WTK path error", 0);
                this.wtkPath = null;
                return false;
            }
            if (!testWTKcldc.exists()) {
                JOptionPane.showMessageDialog(this, "Can't find \"" + testWTKcldc.getPath() + "\" file, please use \"Converter->Converter settings\" for settings", "WTK path error", 0);
                this.wtkPath = null;
                return false;
            }
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.OpenProjectButton = new JButton();
        this.BuildProjectButton = new JButton();
        this.RunProjectButton = new JButton();
        this.ClearConsoleButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.mainConsole = new JTextArea();
        this.ProgressBar = new JProgressBar();
        this.StageLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.createProject = new JMenuItem();
        this.openProject = new JMenuItem();
        this.fileseparator = new JSeparator();
        this.exitProgram = new JMenuItem();
        this.projectMenu = new JMenu();
        this.buildProject = new JMenuItem();
        this.runProject = new JMenuItem();
        this.pjtseparator = new JSeparator();
        this.pjtSettings = new JMenuItem();
        this.converterMenu = new JMenu();
        this.converterSettings = new JMenuItem();
        this.helpMenu = new JMenu();
        this.help = new JMenuItem();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout((LayoutManager)jDialog1Layout);
        jDialog1Layout.setHorizontalGroup((GroupLayout.Group)jDialog1Layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup((GroupLayout.Group)jDialog1Layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("GMConverter(demo version) ");
        this.setIconImage(this.getIconImage());
        this.OpenProjectButton.setText("Open Project");
        this.OpenProjectButton.setName("openProjectButton");
        this.OpenProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.OpenProjectButtonActionPerformed(evt);
            }
        });
        this.BuildProjectButton.setText("Build Project");
        this.BuildProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.BuildProjectButtonActionPerformed(evt);
            }
        });
        this.RunProjectButton.setText("Run Project");
        this.RunProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.RunProjectButtonActionPerformed(evt);
            }
        });
        this.ClearConsoleButton.setText("clear console");
        this.ClearConsoleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ClearConsoleButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.mainConsole.setColumns(20);
        this.mainConsole.setRows(5);
        this.jScrollPane1.setViewportView(this.mainConsole);
        this.StageLabel.setText("Stage :");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.StageLabel, -2, 229, -2).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.ProgressBar, -2, 315, -2)).add((Component)this.jScrollPane1, -1, 575, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 208, Short.MAX_VALUE).add(10, 10, 10).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.StageLabel).add((Component)this.ProgressBar, -2, -1, -2)).addContainerGap()));
        this.fileMenu.setText("File");
        this.createProject.setText("New Project...");
        this.createProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.createProjectActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.createProject);
        this.createProject.getAccessibleContext().setAccessibleName("");
        this.openProject.setText("Open Project");
        this.openProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.openProjectActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProject);
        this.fileMenu.add(this.fileseparator);
        this.exitProgram.setText("Exit");
        this.exitProgram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exitProgramActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitProgram);
        this.jMenuBar1.add(this.fileMenu);
        this.projectMenu.setText("Project");
        this.projectMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.projectMenuActionPerformed(evt);
            }
        });
        this.buildProject.setText("Build Project");
        this.buildProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.buildProjectActionPerformed(evt);
            }
        });
        this.projectMenu.add(this.buildProject);
        this.runProject.setText("Run Project");
        this.projectMenu.add(this.runProject);
        this.projectMenu.add(this.pjtseparator);
        this.pjtSettings.setText("Project Properties");
        this.pjtSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.pjtSettingsActionPerformed(evt);
            }
        });
        this.projectMenu.add(this.pjtSettings);
        this.jMenuBar1.add(this.projectMenu);
        this.converterMenu.setText("Converter");
        this.converterSettings.setText("Converter Settings...");
        this.converterSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.converterSettingsActionPerformed(evt);
            }
        });
        this.converterMenu.add(this.converterSettings);
        this.jMenuBar1.add(this.converterMenu);
        this.helpMenu.setText("Help");
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.help);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.OpenProjectButton, -2, 115, -2).addPreferredGap(0).add((Component)this.BuildProjectButton, -2, 113, -2).addPreferredGap(0).add((Component)this.RunProjectButton, -2, 101, -2).addPreferredGap(0, 133, Short.MAX_VALUE).add((Component)this.ClearConsoleButton)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.ClearConsoleButton).add((Component)this.RunProjectButton).add((Component)this.BuildProjectButton).add((Component)this.OpenProjectButton)).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void RunProjectButtonActionPerformed(ActionEvent evt) {
        if (!MainFrame.currentProject.sucessBuild) {
            return;
        }
        try {
            String[] cmdArray = new String[]{this.wtkPath + File.separator + "bin" + File.separator + "emulator.exe", "\"-Xdescriptor:" + currentProject.getProjectDir() + File.separator + "build" + File.separator + currentProject.getName() + ".jad\""};
            Process runProcess = Runtime.getRuntime().exec(cmdArray, null, new File(this.wtkPath + File.separator + "bin"));
            BufferedReader msgReader = new BufferedReader(new InputStreamReader(runProcess.getInputStream()));
            BufferedReader errReader = new BufferedReader(new InputStreamReader(runProcess.getErrorStream()));
            runProcess.waitFor();
            int exitCode = runProcess.exitValue();
            if (exitCode == 0) {
                String message;
                while ((message = msgReader.readLine()) != null) {
                    this.mainConsole.setForeground(this.gray);
                    this.mainConsole.append(message + "\n");
                }
            } else {
                String message;
                while ((message = errReader.readLine()) != null) {
                    this.mainConsole.setForeground(this.gray);
                    this.mainConsole.append(message + "\n");
                }
            }
        }
        catch (IOException ex) {
            this.mainConsole.setForeground(this.red);
            this.mainConsole.append("IOException ex " + ex.getMessage());
        }
        catch (InterruptedException ex) {
            this.mainConsole.setForeground(this.red);
            this.mainConsole.append("Interrupted Exception");
        }
    }

    private void buildProjectActionPerformed(ActionEvent evt) {
        this.BuildProjectButtonActionPerformed(evt);
    }

    private void appendLoggerMessages(ConverterLogger logger) {
        int i;
        if (logger.messageList.size() > 0) {
            this.mainConsole.setForeground(this.gray);
            for (i = 0; i < logger.messageList.size(); ++i) {
                this.mainConsole.append((String)logger.messageList.get(i) + "\n");
            }
        }
        if (logger.errorList.size() > 0) {
            for (i = 0; i < logger.errorList.size(); ++i) {
                this.mainConsole.append((String)logger.errorList.get(i) + "\n");
            }
        }
    }

    private void BuildProjectButtonActionPerformed(ActionEvent evt) {
        ConverterLogger logger = new ConverterLogger();
        this.ProgressBar.setMinimum(0);
        this.ProgressBar.setMaximum(100);
        this.ProgressBar.setValue(0);
        try {
            File iconfile;
            this.StageLabel.setText("Stage : Conversion of GM file ...");
            gmj2meconverter.Project srcProject = new gmj2meconverter.Project(logger);
            if (!srcProject.createProject(currentProject.getGmfilePath(), currentProject.getProjectDir() + File.separator + "source", currentProject.getMidletName())) {
                throw new BuildProjectException(" Preprocessor: unable to create project for compiler \n");
            }
            if (!srcProject.executeConversion()) {
                throw new BuildProjectException("Error in the conversion");
            }
            this.ProgressBar.setValue(40);
            this.appendLoggerMessages(logger);
            logger.errorList.clear();
            logger.messageList.clear();
            this.StageLabel.setText("Stage : Building ...");
            String[] cmdArray = new String[11];
            File compilerFile = new File(this.jdkPath + File.separator + "bin" + File.separator + "javac.exe");
            File srcFile = new File(currentProject.getProjectDir() + File.separator + "source" + File.separator + "src" + File.separator + currentProject.getMidletName() + File.separator + "*.java");
            cmdArray[0] = compilerFile.getAbsolutePath();
            cmdArray[1] = "-bootclasspath";
            cmdArray[2] = "\"" + this.wtkPath + File.separator + "lib" + File.separator + "cldcapi11.jar;" + this.wtkPath + File.separator + "lib" + File.separator + "midpapi20.jar\"";
            cmdArray[3] = "-g:none";
            cmdArray[4] = "-source";
            cmdArray[5] = "1.3";
            cmdArray[6] = "-target";
            cmdArray[7] = "1.3";
            cmdArray[8] = "-d";
            cmdArray[9] = "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + "tmpclasses\"";
            cmdArray[10] = srcFile.getAbsolutePath();
            try {
                Runtime currentRuntime = Runtime.getRuntime();
                Process compilerProcess = currentRuntime.exec(cmdArray);
                BufferedReader msgReader = new BufferedReader(new InputStreamReader(compilerProcess.getInputStream()));
                BufferedReader errReader = new BufferedReader(new InputStreamReader(compilerProcess.getErrorStream()));
                compilerProcess.waitFor();
                int exitCode = compilerProcess.exitValue();
                if (exitCode != 0) {
                    String str;
                    this.mainConsole.setForeground(this.red);
                    this.mainConsole.append("Compiler errors : \n");
                    while ((str = errReader.readLine()) != null) {
                        this.mainConsole.setForeground(this.gray);
                        this.mainConsole.append(str + "\n");
                    }
                    throw new BuildProjectException(" Error in compiler stage");
                }
                this.mainConsole.setForeground(this.green);
                this.mainConsole.append("Compiler stage : done without errors\n");
            }
            catch (IOException ex) {
                throw new BuildProjectException("Error in compiler stage ");
            }
            catch (InterruptedException ex) {
                throw new BuildProjectException("Error in compiler stage ");
            }
            this.ProgressBar.setValue(60);
            this.StageLabel.setText("Stage : Preverifying ...");
            String[] cmdprevArray = new String[]{"\"" + this.wtkPath + File.separator + "bin" + File.separator + "preverify\"", "-classpath", "\"" + this.wtkPath + File.separator + "lib" + File.separator + "cldcapi11.jar;" + this.wtkPath + File.separator + "lib" + File.separator + "midpapi20.jar\"", "-d", "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + "classes\"", "-target", "CLDC1.1", "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + "tmpclasses\""};
            try {
                Runtime currentRuntime = Runtime.getRuntime();
                Process preverifyProcess = currentRuntime.exec(cmdprevArray);
                BufferedReader msgReader = new BufferedReader(new InputStreamReader(preverifyProcess.getInputStream()));
                BufferedReader errReader = new BufferedReader(new InputStreamReader(preverifyProcess.getErrorStream()));
                preverifyProcess.waitFor();
                int exitCode = preverifyProcess.exitValue();
                if (exitCode != 0) {
                    String str;
                    this.mainConsole.setForeground(this.red);
                    this.mainConsole.append("Preverify errors : \n");
                    while ((str = errReader.readLine()) != null) {
                        this.mainConsole.setForeground(this.gray);
                        this.mainConsole.append(str + "\n");
                    }
                    throw new BuildProjectException(" Error at preverify stage");
                }
                this.mainConsole.setForeground(this.green);
                this.mainConsole.append("Preverify stage : done without errors\n");
            }
            catch (IOException ex) {
                throw new BuildProjectException("Error at preverify stage ");
            }
            catch (InterruptedException ex) {
                throw new BuildProjectException("Error at preverify stage ");
            }
            this.ProgressBar.setValue(70);
            this.StageLabel.setText("Stage : Generation of manifest file  ...");
            if (currentProject.getMidletIconPath() != null && !currentProject.getMidletIconPath().equalsIgnoreCase("") && (iconfile = new File(currentProject.getMidletIconPath())).exists()) {
                try {
                    String dstPath = currentProject.getProjectDir() + File.separator + "source" + File.separator + "res" + File.separator + "sprites" + File.separator + iconfile.getName();
                    FileChannel source = new FileInputStream(currentProject.getMidletIconPath()).getChannel();
                    FileChannel dest = new FileOutputStream(dstPath).getChannel();
                    dest.transferFrom(source, 0L, source.size());
                    source.close();
                    dest.close();
                }
                catch (IOException ex) {
                    throw new BuildProjectException("Error at copy icon file");
                }
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(currentProject.getProjectDir() + File.separator + "build" + File.separator + "manifest.mf")));
                writer.write("Manifest-Version: 1.0");
                writer.newLine();
                writer.write("MIDlet-Vendor: " + currentProject.getVendor());
                writer.newLine();
                writer.write("MIDlet-Name: " + currentProject.getName());
                writer.newLine();
                writer.write("MIDlet-1: " + currentProject.getName() + ", /sprites/" + new File(currentProject.getMidletIconPath()).getName() + ", " + currentProject.getMidletName() + ".GMC" + currentProject.getMidletName());
                writer.newLine();
                writer.write("MIDlet-Version: 1.0");
                writer.newLine();
                writer.write("MicroEdition-Configuration: CLDC-1.1");
                writer.newLine();
                writer.write("MicroEdition-Profile: MIDP-2.0");
                writer.newLine();
                writer.write("MIDlet-Icon: /sprites/" + new File(currentProject.getMidletIconPath()).getName());
                writer.newLine();
                writer.write("Created-By: Game Maker Converter, Version 2.0.1");
                writer.newLine();
                writer.close();
            }
            catch (IOException ex) {
                throw new BuildProjectException("Error at manifest creation");
            }
            this.ProgressBar.setValue(80);
            File jarfile = new File(currentProject.getProjectDir() + File.separator + "build" + File.separator + currentProject.getName() + ".jar");
            if (jarfile.exists()) {
                jarfile.delete();
            }
            this.StageLabel.setText("Stage : jar file creation ...");
            String[] jarArray = new String[]{"\"" + this.jdkPath + File.separator + "bin" + File.separator + "jar.exe\"", "cfm", "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + currentProject.getName() + ".jar\"", "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + "manifest.mf\"", "-C", "\"" + currentProject.getProjectDir() + File.separator + "source" + File.separator + "res\"", ".", "-C", "\"" + currentProject.getProjectDir() + File.separator + "build" + File.separator + "classes\"", "."};
            try {
                Runtime currentRuntime = Runtime.getRuntime();
                Process jarProcess = currentRuntime.exec(jarArray);
                BufferedReader msgReader = new BufferedReader(new InputStreamReader(jarProcess.getInputStream()));
                BufferedReader errReader = new BufferedReader(new InputStreamReader(jarProcess.getErrorStream()));
                jarProcess.waitFor();
                int exitCode = jarProcess.exitValue();
                if (exitCode != 0) {
                    String str;
                    this.mainConsole.setForeground(this.red);
                    this.mainConsole.append("Jar creation stage errors : \n");
                    while ((str = errReader.readLine()) != null) {
                        this.mainConsole.setForeground(this.gray);
                        this.mainConsole.append(str + "\n");
                    }
                    throw new BuildProjectException(" Error at jar creation stage\n");
                }
                this.mainConsole.setForeground(this.green);
                this.mainConsole.append("Create jar : done without errors\n");
            }
            catch (IOException ex) {
                throw new BuildProjectException("Error at jar creation stage\n ");
            }
            catch (InterruptedException ex) {
                throw new BuildProjectException("Error at jar creation stage\n ");
            }
            this.ProgressBar.setValue(90);
            this.StageLabel.setText("Stage : JAD file creation ...");
            File manifest = new File(currentProject.getProjectDir() + File.separator + "build" + File.separator + "manifest.mf");
            manifest.delete();
            try {
                FileChannel jarf = new FileInputStream(currentProject.getProjectDir() + File.separator + "build" + File.separator + currentProject.getName() + ".jar").getChannel();
                long jarsize = jarf.size();
                jarf.close();
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(currentProject.getProjectDir() + File.separator + "build" + File.separator + currentProject.getName() + ".jad")));
                writer.write("MIDlet-Jar-Size: " + jarsize);
                writer.newLine();
                writer.write("MIDlet-Jar-URL: " + currentProject.getName() + ".jar");
                writer.newLine();
                writer.write("MIDlet-Vendor: " + currentProject.getVendor());
                writer.newLine();
                writer.write("MIDlet-Name: " + currentProject.getName());
                writer.newLine();
                writer.write("MIDlet-1: " + currentProject.getName() + ", /sprites/" + new File(currentProject.getMidletIconPath()).getName() + ", " + currentProject.getMidletName() + ".GMC" + currentProject.getMidletName());
                writer.newLine();
                writer.write("MIDlet-Version: 1.0");
                writer.newLine();
                writer.write("MicroEdition-Configuration: CLDC-1.1");
                writer.newLine();
                writer.write("MicroEdition-Profile: MIDP-2.0");
                writer.newLine();
                writer.write("MIDlet-Icon: /sprites/" + new File(currentProject.getMidletIconPath()).getName());
                writer.newLine();
                writer.write("Created-By: Game Maker Converter, Version 2.0.1");
                writer.newLine();
                writer.close();
            }
            catch (IOException ex) {
                throw new BuildProjectException("Error at jad file creation");
            }
            this.ProgressBar.setValue(0);
            this.StageLabel.setText("Stage : Building completed ...");
            this.mainConsole.setForeground(this.green);
            this.mainConsole.append("Building completed without errors .\n");
            MainFrame.currentProject.sucessBuild = true;
            this.setActiveProject(currentProject);
        }
        catch (BuildProjectException ex) {
            MainFrame.currentProject.sucessBuild = false;
            this.mainConsole.setForeground(this.red);
            this.mainConsole.append(ex.getMessage());
            this.setActiveProject(currentProject);
        }
    }

    private void converterSettingsActionPerformed(ActionEvent evt) {
        JDialog dialog = new JDialog(this, "Converter properties", true);
        ConverterProperties cProps = new ConverterProperties(this, dialog);
        dialog.setContentPane(cProps.getContentPane());
        dialog.setPreferredSize(cProps.getPreferredSize());
        dialog.setLocation(cProps.getToolkit().getScreenSize().width / 2 - cProps.getWidth() / 2, cProps.getToolkit().getScreenSize().height / 2 - cProps.getHeight() / 2);
        dialog.setSize(cProps.getSize());
        dialog.setDefaultCloseOperation(0);
        dialog.setVisible(true);
    }

    private void exitProgramActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void pjtSettingsActionPerformed(ActionEvent evt) {
        if (currentProject != null) {
            JDialog dialog = new JDialog(this, " Project properties", true);
            ProjectPropertiesFrame pjtFrame = new ProjectPropertiesFrame(this, currentProject, dialog, false);
            dialog.setContentPane(pjtFrame.getContentPane());
            dialog.setPreferredSize(pjtFrame.getPreferredSize());
            dialog.setLocation(pjtFrame.getToolkit().getScreenSize().width / 2 - pjtFrame.getWidth() / 2, pjtFrame.getToolkit().getScreenSize().height / 2 - pjtFrame.getHeight() / 2);
            dialog.setSize(pjtFrame.getSize());
            dialog.setDefaultCloseOperation(0);
            dialog.setVisible(true);
        }
    }

    private void OpenProjectButtonActionPerformed(ActionEvent evt) {
        this.StageLabel.setText("Stage :");
        this.ProgressBar.setValue(0);
        JFileChooser fChooser = new JFileChooser();
        fChooser.setFileFilter(new PjtFileFilter());
        fChooser.setCurrentDirectory(new File(this.currentDir));
        fChooser.showDialog(this, "Select");
        File f = fChooser.getSelectedFile();
        this.currentDir = fChooser.getCurrentDirectory().getPath();
        if (f != null) {
            Project pjt = new Project("newProject");
            if (pjt.readFromFile(f.getPath())) {
                this.setActiveProject(pjt);
            } else {
                JOptionPane.showMessageDialog(this, "An error occured at the IO operation ", "Error", 0);
                this.setInactiveProject();
            }
        }
    }

    private void openProjectActionPerformed(ActionEvent evt) {
        this.StageLabel.setText("Stage :");
        this.OpenProjectButtonActionPerformed(evt);
    }

    private void ClearConsoleButtonActionPerformed(ActionEvent evt) {
        this.mainConsole.setEditable(true);
        this.mainConsole.setText("");
        this.mainConsole.setEditable(false);
    }

    private void helpActionPerformed(ActionEvent evt) {
    }

    private void createProjectActionPerformed(ActionEvent evt) {
        this.StageLabel.setText("Stage :");
        this.ProgressBar.setValue(0);
        JDialog dialog = new JDialog(this, "New project properties", true);
        Project pjt = new Project("newProject");
        ProjectPropertiesFrame pjtFrame = new ProjectPropertiesFrame(this, pjt, dialog, true);
        dialog.setContentPane(pjtFrame.getContentPane());
        dialog.setPreferredSize(pjtFrame.getPreferredSize());
        dialog.setLocation(pjtFrame.getToolkit().getScreenSize().width / 2 - pjtFrame.getWidth() / 2, pjtFrame.getToolkit().getScreenSize().height / 2 - pjtFrame.getHeight() / 2);
        dialog.setSize(pjtFrame.getSize());
        dialog.setDefaultCloseOperation(0);
        dialog.setVisible(true);
    }

    private void projectMenuActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    public static Project getCurrentProject() {
        return currentProject;
    }

    public static Project getNewProject() {
        return newProject;
    }

    public void setInactiveProject() {
        currentProject = null;
        newProject = null;
        this.BuildProjectButton.setEnabled(false);
        this.RunProjectButton.setEnabled(false);
        this.buildProject.setEnabled(false);
        this.runProject.setEnabled(false);
        this.pjtSettings.setEnabled(false);
        this.setTitle("GMConverter(demo version)");
        this.invalidate();
    }

    public void setActiveProject(Project pjt) {
        if (pjt != null) {
            currentProject = pjt;
            this.BuildProjectButton.setEnabled(true);
            this.RunProjectButton.setEnabled(true);
            this.buildProject.setEnabled(true);
            if (MainFrame.currentProject.sucessBuild) {
                this.runProject.setEnabled(true);
                this.RunProjectButton.setEnabled(true);
            } else {
                this.runProject.setEnabled(false);
                this.RunProjectButton.setEnabled(false);
            }
            this.pjtSettings.setEnabled(true);
            this.setTitle("GMConverter(demo version) - " + pjt.getName());
            this.invalidate();
            this.mainConsole.setForeground(this.gray);
            this.mainConsole.append(" New project opened (" + pjt.getName() + ").\n");
        }
    }
}

