/*
 * Decompiled with CFR 0.152.
 */
package gmconverter;

import gmconverter.MainFrame;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class ConverterProperties
extends JFrame {
    private JDialog owner;
    private MainFrame frame;
    private JButton OKButton;
    private JSeparator jSeparator1;
    private JLabel jrootLabel;
    private JButton sdkBrowseButton;
    private JTextField sdkPath;
    private JLabel titleLabel;
    private JButton wtkBrowseButton;
    private JTextField wtkPath;
    private JLabel wtkrootLabel;

    public ConverterProperties(MainFrame mFrame, JDialog dialog) {
        this.initComponents();
        this.owner = dialog;
        this.frame = mFrame;
        if (this.frame.jdkPath != null && !this.frame.jdkPath.equalsIgnoreCase("")) {
            this.sdkPath.setText(this.frame.jdkPath);
        }
        if (this.frame.wtkPath != null && !this.frame.wtkPath.equalsIgnoreCase("")) {
            this.wtkPath.setText(this.frame.wtkPath);
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jrootLabel = new JLabel();
        this.wtkrootLabel = new JLabel();
        this.sdkPath = new JTextField();
        this.wtkPath = new JTextField();
        this.OKButton = new JButton();
        this.sdkBrowseButton = new JButton();
        this.wtkBrowseButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Converter properties");
        this.titleLabel.setFont(new Font("Monospaced", 1, 12));
        this.titleLabel.setText("Converter properties :");
        this.jrootLabel.setText("Java SDK root directory:");
        this.wtkrootLabel.setText("WTK 2.x root directory :");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConverterProperties.this.OKButtonActionPerformed(evt);
            }
        });
        this.sdkBrowseButton.setText("Browse...");
        this.sdkBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConverterProperties.this.sdkBrowseButtonActionPerformed(evt);
            }
        });
        this.wtkBrowseButton.setText("Browse...");
        this.wtkBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConverterProperties.this.wtkBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jSeparator1, -1, 431, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jrootLabel, -1, -1, Short.MAX_VALUE).add((Component)this.wtkrootLabel, -1, 118, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sdkPath, -2, 224, -2).add((Component)this.wtkPath, -1, 224, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sdkBrowseButton).add((Component)this.wtkBrowseButton))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel, -2, 163, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(166, 166, 166).add((Component)this.OKButton, -2, 94, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.titleLabel, -2, 24, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jrootLabel).add((Component)this.sdkPath, -2, -1, -2).add((Component)this.sdkBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.wtkrootLabel).add((Component)this.wtkPath, -2, -1, -2).add((Component)this.wtkBrowseButton)).add(20, 20, 20).add((Component)this.OKButton).addContainerGap()));
        this.pack();
    }

    private void sdkBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setFileSelectionMode(1);
        fChooser.showDialog(this, "Select directory");
        File f = fChooser.getSelectedFile();
        if (f != null) {
            this.sdkPath.setText(f.getPath());
        } else {
            this.sdkPath.setText("");
        }
    }

    private void wtkBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setFileSelectionMode(1);
        fChooser.showDialog(this, "Select directory");
        File f = fChooser.getSelectedFile();
        if (f != null) {
            this.wtkPath.setText(f.getPath());
        } else {
            this.wtkPath.setText("");
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.frame.jdkPath = this.sdkPath.getText();
        this.frame.wtkPath = this.wtkPath.getText();
        if (this.frame.testConfigPaths()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(MainFrame.CONFIG_FILE_NAME)));
                writer.write(this.frame.jdkPath);
                writer.newLine();
                writer.write(this.frame.wtkPath);
                writer.newLine();
                writer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error in writing of config file", "Error in config", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Error in config", "Error in config", 0);
            this.sdkPath.setText("");
            this.wtkPath.setText("");
        }
        this.dispose();
        this.owner.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

